#ifndef __ATTRIBUTE_H__
#define __ATTRIBUTE_H__

#include "global.h"
#include "repertoire.h"

/* type declarations */
#define TYPE_INT  1
#define TYPE_BOOL 2
#define TYPE_SET  3
#define TYPE_HASH 4
#define TYPE_ATTR 5
#define TYPE_FUNC 7

typedef struct {
	char *name;
	long attribute_handle;
	long type;
	u64 default_value;
	union {
		struct {
			u64 largest;
			u64 smallest;
			} integer;
		struct {
      	int reserved;
		 	} boolean;
		struct {
			int size;
			} set;
		REPERTOIRE_VALUES rep;
		}param;
		
	} ATTRIBUTE;


typedef struct {
	int random;
	u64 value;
	union {
		struct {
			u64 largest;
			u64 smallest;
			} integer;
		struct {
			int size;
			u64 mask_on;
			u64 mask_random;
			u64 mask_off;
			} set;
		struct {
      	int reserved;
			} boolean;
		REPERTOIRE_PARAMS rep;
		} param;
			
	} ATTRIBUTE_PARAM;
	
void init_attributes(void);
ATTRIBUTE *add_new_attribute(char *name);
void dump_attributes(FILE *fout);
long num_attributes(void);	
char *type2name(long type);
ATTRIBUTE *get_attribute(long i);
long get_attribute_index(char *name);
u64 generate_value(ATTRIBUTE *a,ATTRIBUTE_PARAM *ap);
char *get_attribute_name(long index);
void dump_param(FILE *fout, ATTRIBUTE *a,ATTRIBUTE_PARAM *ap);
void evolve_attributes(void);

#endif
